#include "GetPoint.js"

function GetCircleRadius( pointpicker, factory, enablevertical )
{
	var ui = moi.ui;

	ui.beginUIUpdate();
	ui.hideUI( 'CenterPrompt' );
	ui.showUI( 'RadiusPrompt' );
	ui.showUI( 'RadiusOptions' );
	ui.endUIUpdate();

	factory.setInput( 1, pointpicker.ptframe );

	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, false );
	pointpicker.stickToSurfacesMode = 'max';
	pointpicker.disableVerticalStraightSnap = true;

	pointpicker.bindResultPt( factory.getInput(2) );
	pointpicker.bindResultOrientation( factory.getInput(1) );

	pointpicker.bindFunc( ui.commandUI.OnPoint );
	
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return false;

		if ( pointpicker.event == 'finished' )
		{
			break;
		}
		else if ( pointpicker.event == 'distanceinput' || pointpicker.event == 'circumference' )
		{
		    factory.setInput( 0, ui.commandUI.g_UseRadius );

		    if ( pointpicker.event == 'distanceinput' )
		    {
		        factory.setInput( 3, ui.commandUI.distanceinput.value );
		    }
		    else
		    {
		        var circ = ui.commandUI.circumference.value;
		        factory.setInput( 3, ui.commandUI.g_UseRadius ? circ / (2.0 * Math.PI) : circ / Math.PI );
		    }

			factory.update();
			
			var isfinished = true;
			
			// Vertical circles need to have the radius point specified, not just a value for
			// the radius. Check if vertical checkbox is enabled, and keep going if it is.
			if ( enablevertical && ui.commandUI.vertical && ui.commandUI.vertical.value )
			{
				isfinished = false;

				// Remove the binding that updates the distance input.
				pointpicker.clearBindings();
				pointpicker.bindResultPt( factory.getInput(2) );
				pointpicker.bindResultOrientation( factory.getInput(1) );
			}
				
			if ( isfinished )
				break;
		}
	}

	return true;
}

function GetCircle( factory, enablevertical )
{
	var pointpicker = moi.ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return false;
		
	return GetCircleRadius( pointpicker, factory, enablevertical );
}